/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.JICP;

import jade.imtp.leap.JICP.Connection;

class ConnectionWrapper {
    private Connection myConnection;
    private boolean oneShot;
    private boolean locked;
    private boolean closed;
    private boolean reused;
    private long lastUsage;

    ConnectionWrapper(Connection c) {
        this.myConnection = c;
        this.oneShot = false;
        this.reused = false;
        this.locked = true;
        this.closed = false;
    }

    final Connection getConnection() {
        return this.myConnection;
    }

    final void setOneShot() {
        this.oneShot = true;
    }

    final boolean isOneShot() {
        return this.oneShot;
    }

    final void setReused() {
        this.reused = true;
    }

    final boolean isReused() {
        return this.reused;
    }

    synchronized boolean lock() {
        if (this.locked) {
            return false;
        }
        this.locked = true;
        return true;
    }

    synchronized void unlock() {
        this.locked = false;
        this.lastUsage = System.currentTimeMillis();
        if (this.closed) {
            this.close();
        }
    }

    synchronized void close() {
        if (!this.locked) {
            try {
                this.myConnection.close();
            }
            catch (Exception e) {}
        } else {
            this.closed = true;
        }
    }
}

